// SendLetterTunnelThread.java
// Both 14 feb

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;

public class SendLetterTunnelThread extends Thread {
  public Letter2 L;
  private int startX, startY, endX, endY, x ,y;
  private final int offsetY = 50;
  Graphics g;
  ShowMobileIPCanvas canvas;
  Agent sender;
  Package P;
  
  public void start(Agent sender,ShowMobileIPCanvas father) {
    this.canvas = father; 
    this.startX = sender.x; this.startY = sender.y; 
    this.endX = Globals.MH.connected.x; 
    this.endY = Globals.MH.connected.y; 
    this.x = sender.x; this.y = sender.y;
    this.sender =sender;
    L = new Letter2(canvas);
    g = canvas.getGraphics();
    super.start(); // run() MUST be started from Thread.start()
  }
  
  public void run() {
    // Print first message
    canvas.frame.textArea1.appendHiLit(canvas.tunnelText1);
    Globals.actionAllowed = false; // MH interaction disabled
    canvas.frame.setDisabled();
    // Define letter informationText
    L.info =  "Contains data to MH";
    P = new Package(startX, startY + offsetY, canvas);
    L.drawLetter(g, startX, startY);
    P.drawPackage(g);
    P.openPackage(g);

    P.letterInPackage(g, L);
    P.closePackage(g);
    canvas.frame.setCont();
    canvas.frame.textArea1.appendHiLit(canvas.tunnelText2);
    sendPackage(endX, endY + offsetY);
    canvas.frame.setDisabled();
    canvas.frame.textArea1.appendHiLit(canvas.tunnelText3);
    P.openPackage(g);
    P.letterOutPackage(g, L);
    P.erasePackage(g); // Letter has arrived and package is destroyed
    canvas.paint(g);
    L.drawLetter(g, endX, endY);
    canvas.frame.textArea1.appendHiLit(canvas.tunnelText4);
    pause(Globals.pauseTime);

    canvas.sendLetter(sender, Globals.MH.connected); // Data is sent to MH from FA
    
    stop(); // Make the Thread disappear
  } // end run()

   // Animation of Letter
  private void sendPackage(int toX, int toY) {
    int biggest = Math.max(Math.abs(toY - P.y), Math.abs(toX - P.x));
    float dx = (float) (toX - P.x) / biggest;
    float dy = (float) (toY - P.y) / biggest;
    float xtemp = (float) P.x;
    float ytemp = (float) P.y ; 
    float minToY = toY - Math.abs(dy), maxToY = toY + Math.abs(dy);
    float minToX = toX - Math.abs(dx), maxToX = toX + Math.abs(dx);
  
  
    //  while ((P.x != toX) && (P.y != toY)) { 
    while (!(((ytemp < maxToY) && (ytemp > minToY)) && 
	     ((xtemp < maxToX) && (xtemp > minToX)))) {
      if (Globals.contAllowed) { // Check whether user pressed Stop 
     	xtemp  = xtemp+dx;
	ytemp  = ytemp+dy;
	g.setColor(Color.lightGray);
	g.fillRect(P.x-7, P.y-1, 38, 26);
	P.x = (int) xtemp;
	P.y = (int) ytemp;
	canvas.paint(g); 
	P.drawPackage(g); 
	 try {  
	  sleep(Globals.sleepTime);
	 } catch (InterruptedException e) {break;}
      }
      else { // Wait for user to press continue
	canvas.frame.setStop(); // Activate Stopbutton
	this.suspend();
      }
    } // end while   
  } 
    
  public void pause(int time) {
    try {  
      Thread.sleep(time);
    } catch (InterruptedException e) {}
  }
}
	
